
/*-------------------------------------------------------------------------*
 *                                                                         *
 *  SCP2ASC                         Hauptprogramm : scp2asc                *
 *                                                                         *
 *  Convert SCP 2 ASC File                                                 *
 *                                                                         *
 *-------------------------------------------------------------------------*
 *                                                                         *
 *  (C) 1991-96 by Firma Ingrid Schmidt / Frankfurt / Germany              *
 *  Written 1990/91 by Andreas Claus Schmidt                               *
 *                                                                         *
 *-------------------------------------------------------------------------*
 *                                                                         *
 *  Version 1.0                                                            *
 *                                                                         *
 *  Alle Rechte vorbehalten, auch die der fotomechanischen Wiedergabe und  *
 *  der Speicherung in elektronischen Medien.                              *
 *  Die Nutzung der in diesem Programm gezeigten Modelle und Arbeiten ist  *
 *  nicht zulssig.                                                        *
 *  Fehler in Programmen knnen nicht vollstndig ausgeschlossen werden.   *
 *  Die Firma und sie Autor knnen fr fehlerhafte Programme und deren     *
 *  Folgen weder eine juristische Verantwortung noch irgendeine Haftung    *
 *  bernehmen.                                                            *
 *                                                                         *
 *-------------------------------------------------------------------------*/

    #include "scp2asc.h"
    
    int mode,expt;
   
/*-----------------------------------------------------------------------*/

double wandel_scal ( int offset1 )

{
    unsigned char i;
    unsigned char te1[20];
    unsigned char te2[20];
    double zeit;
    strcpy (te2,"");


h12:i = daten.parameterblock[ offset1 ];
    if ( i==46 ) goto h11;
    if ( i>57  ) goto h13;
    if ( i<48  ) goto h13;

h11:sprintf(te1,"%c",i);
    strcat (te2,te1);
    offset1++;
    goto h12;

h13:zeit = atof(te2);
    if ( daten.parameterblock[ offset1 ] == 109 )
       zeit /= 1000.0;
    if ( daten.parameterblock[ offset1 ] == 117 )
       zeit /= 1000000.0;

    return ( zeit );
}

/*-----------------------------------------------------------------------*/

/* file speichern */


unsigned char save_do ( unsigned char *filename )

{
    FILE *dz;
    unsigned char i;
    unsigned int  n;
    unsigned char status = 0;
    
    if ( (dz = fopen( filename, "w")) != NULL )
       {
       fprintf ( dz, "%lu\n", daten.date );
       fprintf ( dz, "%lf\n", daten.zeit );
       fprintf ( dz, "%u\n" , daten.maximal );
       
       for ( i=0 ; i<8 ; i++ )
          {
          if ( channel[i].belegt )
             fprintf ( dz, "%u\t" , i+1 );
          }
       fprintf( dz, "%c", 13);
       
       for ( i=0 ; i<8 ; i++ )
          {
          if ( channel[i].belegt )
             fprintf ( dz, "%lf\t", channel[i].volt );
          }
       fprintf( dz, "%c", 13);
             
       for ( n=0 ; n<daten.maximal ; n++ )
          {
          for ( i=0 ; i<8 ; i++ )
             {
             if ( channel[i].belegt )
                fprintf ( dz, "%u\t", channel[i].array[n] );
             }
          fprintf( dz, "%c", 13);
          }
       fclose ( dz );
       }
    else
       status = 1;

    return( status );
}

/*-----------------------------------------------------------------------*/

/* file laden */


unsigned char load_do ( unsigned char *filename )

{
    int i,j,offset1;
    int a, b;
    FILE *dz;
    unsigned char status = 0;
    unsigned char kanal;
    unsigned char ver;
    unsigned char text[30];
    unsigned int old_datenmaximal;
    unsigned char last_kanal;
    daten.raster = 0;

    if ( (dz = fopen( filename, "rb")) != NULL )
       {
       fgetc ( dz );
       a = fgetc ( dz );
       b = fgetc ( dz );
       fclose ( dz );
       }
    if ( !(a==13 && b==10) )
       {
       if ( (dz = fopen( filename, "rb")) != NULL )
	  {
	  expt = fgetc ( dz );
	  ver  = fgetc ( dz );
	  if ( ver > 1 )
	     status = 1;
	  if ( fgetc ( dz ) != 255 )
	     status = 1;
	  if ( !status && ( ver == 0 ) )
	     {
	     daten.scope = fgetc ( dz );

	     fread ( &daten.time, sizeof( unsigned long ), 1, dz );
	     fread ( &daten.date, sizeof( unsigned long ), 1, dz );

	     for ( i=0 ; i<48 ; i++ )
		daten.comment[i] = fgetc ( dz );

	     channel[0].offset = (int)fgetc( dz );
	     channel[1].offset = (int)fgetc( dz );

	     if ( !expt )
		{
		fgetc ( dz );
		fgetc ( dz );
		}
	     else
		{
		channel[0].offset = (int)fgetc( dz );
		channel[1].offset = (int)fgetc( dz );
		fread ( &channel[2].volt, sizeof( double ), 1, dz );
		fread ( &channel[3].volt, sizeof( double ), 1, dz );
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.pos[0] = a;
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.pos[1] = a;
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.fenster1 = a;
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.fenster2 = a;
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.curs[0] = a;
		fread ( &a  , sizeof( int )  , 1, dz );
		daten.curs[1] = a;
		fread ( &daten.dot_join, sizeof( daten.dot_join ), 1, dz );
		fread ( &daten.split   , sizeof( daten.split )   , 1, dz );
		fread ( &channel[0].color, sizeof( channel[0].color ), 1, dz );
		fread ( &channel[1].color, sizeof( channel[0].color ), 1, dz );
		fread ( &channel[2].color, sizeof( channel[0].color ), 1, dz );
		fread ( &channel[3].color, sizeof( channel[0].color ), 1, dz );
		fread ( &a, sizeof( int ), 1, dz );
		daten.aktiv  = a;
		fread ( &a, sizeof( int ), 1, dz );
		daten.passiv = a;
		fread ( &a, sizeof( int ), 1, dz );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].darstellen = 1;
		   else
		      channel[i].darstellen = 0;
		   }

		fread ( &a, sizeof( int ), 1, dz );

		fread ( &a, sizeof( int ), 1, dz );
		daten.dots = a;

		fread ( &a, sizeof( int ), 1, dz );
		daten.mode = a;

		fread ( &a, sizeof( int ), 1, dz );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].belegt = 1;
		   else
		      channel[i].belegt = 0;
		   }
		fread ( &a, sizeof( int ), 1, dz );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].eingelesen = 1;
		   else
		      channel[i].eingelesen = 0;
		   }
		fread ( &a, sizeof( int ), 1, dz );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].calc = 1;
		   else
		      channel[i].calc = 0;
		   }
		fread ( &a, sizeof( int ), 1, dz );
		}
	     for ( i=0 ; i<256 ; i++ )
		daten.parameterblock[i] = fgetc ( dz );

	     daten.pretrigger = (int)wandel_scal( 83 );
	     channel[0].volt  = wandel_scal( 20 );
	     channel[1].volt  = wandel_scal( 36 );
	     daten.zeit       = wandel_scal( 51 );

	     if ( daten.parameterblock[ 1 ] )
		daten.xy = 1;
	     else
		daten.xy = 0;

	     if ( !expt )
		{
		if ( !daten.parameterblock[2] )
		   {
		   if ( daten.parameterblock[ 3 ] == 0 )
		      {
		      channel[1].belegt = 1;
		      j = 1;
		      }
		   else
		      {
		      channel[0].belegt = 1;
		      j = 0;
		      }

		   if ( daten.scope==48 )
		      daten.maximal = 4096;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      channel[j].array[i] = fgetc ( dz );
		   }
		else
		   {
		   channel[0].belegt = 1;
		   channel[1].belegt = 1;
		   if ( daten.scope == 48 )
		      daten.maximal = 2048;
		   if ( daten.scope == 253 )
		      daten.maximal = 2048;
		   if ( daten.scope == 252 )
		      daten.maximal = 1024;
		   if ( daten.scope == 208 )
		      daten.maximal = 1024;
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      channel[0].array[i] = fgetc ( dz );
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      channel[1].array[i] = fgetc ( dz );

		   }
		}
	     else
		{
		if ( !daten.parameterblock[2] )
		   {
		   if ( daten.scope == 48 )
		      daten.maximal = 4096;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   }
		else
		   {
		   if ( daten.scope==48 )
		      daten.maximal = 2048;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   }

		for ( i=0 ; i<daten.maximal ; i++ )
		   channel[0].array[i] = fgetc ( dz );
		for ( i=0 ; i<daten.maximal ; i++ )
		   channel[1].array[i] = fgetc ( dz );
		for ( i=0 ; i<daten.maximal ; i++ )
		   channel[2].array[i] = fgetc ( dz );
		for ( i=0 ; i<daten.maximal ; i++ )
		   channel[3].array[i] = fgetc ( dz );
		}
	     if ( !expt )
		{
		daten.aktiv  =  0;
		daten.passiv =  1;
		for ( i = 8 ; i < 8 ; i++ )
		   if ( channel[i].belegt )
		      {
		      channel[i].darstellen = 1;
		      channel[i].eingelesen = 1;
		      channel[i].calc       = 1;
		      }
		   else
		      {
		      channel[i].darstellen = 1;
		      channel[i].eingelesen = 1;
		      channel[i].calc       = 1;
		      }
		daten.dots =  daten.maximal/512;
		daten.mode =  1;
		daten.dot_join = 1;
		daten.split = 0;
		daten.fenster1 = 256 * daten.dots;
		daten.fenster2 = daten.fenster1 - 100;
		daten.pos[0]   = daten.fenster1;
		daten.pos[1]   = daten.fenster2;
		}
	     }
	  if ( !status && ( ver == 1 ) )
	     {

             old_datenmaximal = daten.maximal;
             status = 0;
                
	     fread ( &daten, sizeof ( struct datendef ), 1, dz );
	     last_kanal = 0;
	     do
	       {
	       kanal = fgetc ( dz );
               
               /*							*/
               /* beheben das fehlers beim einlesen in der beta Version */
               /*			     				*/
               if ( kanal && last_kanal >= kanal )
                  kanal = last_kanal + 1;
               if ( kanal > 8 )
                  kanal = 1;
                  
	       if ( kanal )
		  {
		  fread ( ( &channel[(kanal-1)].belegt ), sizeof ( struct channeldef )-1, 1, dz );
		  channel[(kanal-1)].kanal = kanal;
                  last_kanal = kanal;
		  }
	       }
	     while ( kanal );

	     }
	  fclose ( dz );
	  }
       else
	  status = 1;
       }
    else
       {
       if ( (dz = fopen( filename, "r")) != NULL )
	  {
	  fscanf ( dz, "%d\n", &expt );
	  fscanf ( dz, "%d\n", &a );
	  fscanf ( dz, "%d\n", &b );
	  if ( a==0 && b==255 )
	     {
	     fscanf ( dz, "%d\n", &daten.scope );

	     fscanf ( dz, "%lu\n", &daten.time );
	     fscanf ( dz, "%lu\n", &daten.date );
	     fscanf ( dz, "%s\n", daten.comment );
	     fscanf ( dz, "%d\n", &channel[0].offset );
	     fscanf ( dz, "%d\n", &channel[1].offset );
	     if ( !expt )
		{
		fscanf ( dz, "%d\n", &a );
		fscanf ( dz, "%d\n", &a );
		}
	     else
		{
		fscanf ( dz, "%d\n", &channel[2].offset );
		fscanf ( dz, "%d\n", &channel[3].offset );
		fscanf ( dz, "%le\n", &channel[2].volt );
		fscanf ( dz, "%le\n", &channel[3].volt );
		fscanf ( dz, "%d\n", &daten.pos[0] );
		fscanf ( dz, "%d\n", &daten.pos[1] );
		fscanf ( dz, "%d\n", &daten.fenster1 );
		fscanf ( dz, "%d\n", &daten.fenster2 );
		fscanf ( dz, "%d\n", &a );
		daten.curs[0] = a;
		fscanf ( dz, "%d\n", &a );
		daten.curs[1] = a;
		fscanf ( dz, "%d\n", &daten.dot_join );
		fscanf ( dz, "%d\n", &daten.split );
		fscanf ( dz, "%d\n", &channel[0].color );
		fscanf ( dz, "%d\n", &channel[1].color );
		fscanf ( dz, "%d\n", &channel[2].color );
		fscanf ( dz, "%d\n", &channel[3].color );
		fscanf ( dz, "%d\n", &a );
		daten.aktiv = a;
		fscanf ( dz, "%d\n", &a );
		daten.passiv = a;


		fscanf ( dz, "%d\n", &a );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].darstellen = 1;
		   else
		      channel[i].darstellen = 0;
		   }

		fscanf ( dz, "%d\n", &a );

		fscanf ( dz, "%d\n", &a );
		daten.dots = a;

		fscanf ( dz, "%d\n", &a );
		daten.mode = a;

		fscanf ( dz, "%d\n", &a );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].belegt = 1;
		   else
		      channel[i].belegt = 0;
		   }
		fscanf ( dz, "%d\n", &a );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].eingelesen = 1;
		   else
		      channel[i].eingelesen = 0;
		   }
		fscanf ( dz, "%d\n", &a );
		for ( i = 0 ; i < 8 ; i++ )
		   {
		   j = 1 << i;
		   if ( j & a )
		      channel[i].calc = 1;
		   else
		      channel[i].calc = 0;
		   }
		fscanf ( dz, "%d\n", &a );
		}
	     for ( i=0 ; i<256 ; i++ )
		{
		fscanf ( dz, "%d\n", &a );
		daten.parameterblock[i] = (char)a;
		}
	     daten.pretrigger = (int)wandel_scal( 83 );;
	     channel[0].volt  = wandel_scal( 20 );
	     channel[1].volt  = wandel_scal( 36 );
	     daten.zeit       = wandel_scal( 51 );
	     if ( daten.parameterblock[ 1 ] )
		daten.xy = 1;
	     else
		daten.xy = 0;
	     if ( !expt )
		{
		if ( !daten.parameterblock[2] )
		   {
		   if ( daten.parameterblock[ 3 ] == 0 )
		      {
		      channel[1].belegt = 1;
		      j = 1;
		      }
		   else
		      {
		      channel[0].belegt = 1;
		      j = 0;
		      }

		   if ( daten.scope==48 )
		      daten.maximal = 4096;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      {
		      fscanf ( dz, "%d\n", &a );
		      channel[j].array[i] = (char)a;
		      }
		   }
		else
		   {
		   channel[0].belegt = 1;
		   channel[1].belegt = 1;
		   if ( daten.scope==48 )
		      daten.maximal = 2048;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      {
		      fscanf ( dz, "%d\n", &a );
		      channel[0].array[i] = (char)a;
		      }
		   for ( i = 0 ; i < daten.maximal ; i++ )
		      {
		      fscanf ( dz, "%d\n", &a );
		      channel[1].array[i] = (char)a;
		      }
		   }
		}
	     else
		{
		if ( !daten.parameterblock[2] )
		   {
		   if ( daten.scope==48 )
		      daten.maximal = 4096;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   }
		else
		   {
		   if ( daten.scope==48 )
		      daten.maximal = 2048;
		   if ( daten.scope==253 )
		      daten.maximal = 2048;
		   if ( daten.scope==252 )
		      daten.maximal = 1024;
		   if ( daten.scope==208 )
		      daten.maximal = 1024;
		   }
		for ( i = 0 ; i < daten.maximal ; i++ )
		   {
		   fscanf ( dz, "%d\n", &a );
		   channel[0].array[i] = (char)a;
		   }
		for ( i = 0 ; i < daten.maximal ; i++ )
		   {
		   fscanf ( dz, "%d\n", &a );
		   channel[1].array[i] = (char)a;
		   }
		for ( i = 0 ; i < daten.maximal ; i++ )
		   {
		   fscanf ( dz, "%d\n", &a );
		   channel[2].array[i] = (char)a;
		   }
		for ( i = 0 ; i < daten.maximal ; i++ )
		   {
		   fscanf ( dz, "%d\n", &a );
		   channel[3].array[i] = (char)a;
		   }
		}
	     if ( !expt )
		{
		daten.aktiv  =  0;
		daten.passiv =  1;
		daten.dots =  daten.maximal/512;
		daten.mode =  1;
		daten.dot_join = 1;
		daten.split = 0;
		daten.fenster1 = 256 * daten.dots;
		daten.fenster2 = daten.fenster1 - 100;
		daten.pos[0]   = daten.fenster1;
		daten.pos[1]   = daten.fenster2;
		}
	     }
	  fclose ( dz );
	  }
       else
	  status = 1;
       }
    return ( status );

}

/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/

void printline ( void )

{
printf("-----------------------------------------------------------\n");
}

/*-----------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
	char  *s;
        unsigned char filename1[15];
        unsigned char filename2[15];

        printf( "\n>>>> ---- SCP2ASC  V1.00  File - Covert - Utility ---- <<<<");
        printf( "\n      (C)1993 by Ingrid Schmidt / Frankfurt / Germany\n");
        printline();

        printline();
        
        if ( 1 == 1)
           {
   	   if ( argc != 2 || ( strlen (argv[1]) > 8 ) )
              {
	      printf("To convert filename.scp to filename.asc type:\nc:\\>scp2asc filename\n");
              printline();
 	      return;
	      }
                
           strcpy ( filename1, argv[1] );
           strcpy ( filename2, argv[1] );
           strcat ( filename1, ".scp" );
           strcat ( filename2, ".asc" );

           printf ("Convert %s to %s\n", filename1, filename2 );
           printf ("Please wait !!!\r");

           if ( !load_do( filename1 ) )
              if ( !save_do( filename2 ) )
                 printf ("Complete         \n");
              else
                 printf ("File save error  \n");
           else
              printf ("File open error  \n");
           }
        else
           printf (" ");

        printline();
}

/*-----------------------------------------------------------------------*/

